/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.util;

import noppes.npcs.api.IPos;
import noppes.npcs.api.util.IRayTraceVec;
import noppes.npcs.api.wrapper.BlockPosWrapper;

public class RayTraceVec
implements IRayTraceVec {
    public static RayTraceVec EMPTY = new RayTraceVec();
    private double yaw = 0.0;
    private double distance = 0.0;
    private double x = 0.0;
    private double y = 0.0;
    private double z = 0.0;
    private double sx = 0.0;
    private double sy = 0.0;
    private double sz = 0.0;

    public void calculatePos(double cx, double cy, double cz, double yaw, double pitch, double distance) {
        this.sx = cx;
        this.sy = cy;
        this.sz = cz;
        if (distance < 0.0) {
            distance *= -1.0;
        }
        this.x = cx + Math.sin(yaw * Math.PI / 180.0) * distance * -1.0;
        this.y = cy + Math.sin(pitch * Math.PI / 180.0) * distance;
        this.z = cz + Math.cos(yaw * Math.PI / 180.0) * distance;
        this.distance = distance;
        this.yaw = yaw;
    }

    public void calculateVec(double dx, double dy, double dz, double mx, double my, double mz) {
        this.sx = dx;
        this.sy = dy;
        this.sz = dz;
        double hVal = 1.5 + my - dy;
        double rad0 = Math.PI / 180;
        double rad1 = 57.29577951308232;
        this.distance = Math.sqrt(Math.pow(mx - dx, 2.0) + Math.pow(my - dy, 2.0) + Math.pow(mz - dz, 2.0));
        if (hVal < 0.35) {
            hVal = 0.35;
        }
        double xVal = mx - dx;
        double zVal = mz - dz;
        this.y = (-3.0 + Math.sqrt(9.0 - 16.0 * (-0.75 - hVal))) / 8.0;
        double radiusXZ = Math.sqrt(Math.pow(xVal, 2.0) + Math.pow(zVal, 2.0));
        double impXZ = -4.5 + Math.sqrt(20.25 + 4.0 * radiusXZ);
        if (xVal == 0.0) {
            this.yaw = dz > mz ? 180.0 : 0.0;
        } else {
            double v = Math.atan(zVal / xVal) * rad1;
            this.yaw = xVal <= 0.0 ? 90.0 + v : 270.0 + v;
        }
        this.yaw %= 360.0;
        if (this.yaw < 0.0) {
            this.yaw += 360.0;
        }
        this.x = Math.sin(this.yaw * rad0) * impXZ * -1.0;
        this.z = Math.cos(this.yaw * rad0) * impXZ;
    }

    @Override
    public double getYaw() {
        return this.yaw;
    }

    @Override
    public double getDistance() {
        return this.distance;
    }

    @Override
    public IPos getStartPos() {
        return new BlockPosWrapper(this.sx, this.sy, this.sz);
    }

    @Override
    public IPos getEndPos() {
        return new BlockPosWrapper(this.x, this.y, this.z);
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public double getZ() {
        return this.z;
    }
}

